﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Customers
{
    public partial class Customers : System.Web.UI.Page
    {
        private static int mode;
        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);
           
            if (!IsPostBack)
            {
                mode = 0;
                if (Request.QueryString["mode"] != null)
                {
                    try
                    {
                        mode = int.Parse(Request.QueryString["mode"].ToString());
                    }
                    catch { }
                }

                BindUserList(string.Empty, DateTime.MinValue, DateTime.MinValue, mode);
            }
            
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindUserList(string.Empty,DateTime.MinValue,DateTime.MinValue,0);
            Master.ExportToExcel<UserAccount>(grdCustomers, "CustomerReport");
        }

        private void BindUserList(string searchWord, DateTime fromDate, DateTime toDate, int mode)
        {
            List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, searchWord, fromDate, toDate);
            pbList = (from pb in pbList
                      where pb.UserRoleType.Trim().ToLower() == "user" && pb.IsActive
                      orderby pb.CreatedDate descending
                      select pb).ToList<UserAccount>();

            switch (mode)
            {
                case 1:
                    pbList = (from pl in pbList
                              where pl.CustomerType.ToLower() == "public"
                              select pl).ToList<UserAccount>();
                    break;
                case 2:
                    pbList = (from pl in pbList
                              where pl.CustomerType.ToLower() == "designers"
                              select pl).ToList<UserAccount>();
                    break;
                case 3:
                    pbList = (from pl in pbList
                              where pl.CustomerType.ToLower() == "resellers"
                              select pl).ToList<UserAccount>();
                    break;
                case 4:
                    pbList = (from pl in pbList
                              where pl.CustomerType.ToLower() == "others" || string.IsNullOrEmpty(pl.CustomerType)
                              select pl).ToList<UserAccount>();
                    break;
            }

            grdCustomers.DataSource = pbList;
            grdCustomers.DataBind();

            if (pbList.Count == 0)
                WebUtilities.ShowMessage(this, "No Customer Record found");
        }

        protected void grdCustomers_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdCustomers.PageIndex = e.NewPageIndex;
            BindUserList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                     (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
        }

        protected void grdCustomers_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblDOB = e.Row.FindControl("lblDOB") as Label;

                UserAccount curUser = (UserAccount)e.Row.DataItem;

                lblDOB.Text = curUser.DOB != DateTime.MinValue ? curUser.DOB.ToString("dd/MM/yyyy") : string.Empty;
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtFromDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtFromDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid From Date");
                return;
            }

            if (txtToDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtToDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid To Date");
                return;
            }

            BindUserList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindUserList(string.Empty, DateTime.MinValue, DateTime.MinValue, 0);
        }
    }
}